// ChangeMesssageWindowSkin.js Ver.1.0.1
// MIT License (C) 2022 あわやまたな
// http://opensource.org/licenses/mit-license.php

/*:
* @target MZ
* @plugindesc メッセージウィンドウのスキンを変更します。
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/
* @help 以下のウィンドウスキンのみ別の画像に差し替えます。
* ・Window_Message //文章の表示
* ・Window_NameBox //名前
* ・Window_ChoiceList //選択肢の表示
* ・Window_NumberInput //数値入力の処理
* ・Window_GameEnd //ゲーム終了
* ・Window_MenuActor //メニューのスキル、アイテム対象選択
*
* SelectableWindow.jsでWindow_MenuActorが指定されている場合、
* 本プラグインとSelectableWindow.jsのどちらがリストの上にあるかで
* 外観が変化します。
*
* [更新履歴]
* 2022/07/31：Ver.1.0.0　公開。
* 2022/12/23：Ver.1.0.1　対象にWindow_MenuActorを追加。
*
* @param windowSkin
* @text ウィンドウスキン
* @desc ファイル名を指定します。
* @default MessageWindow
* @type file
* @dir img/system
*
* @param windowOpacity
* @text ウィンドウ不透明度
* @desc リザルトウィンドウの不透明度を指定します。
* -1でシステムの初期値。
* @default 255
* @type number
* @min -1
*
*/

'use strict';

{
	//プラグイン名取得。
	const script = document.currentScript;
	const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];

	const parameters = PluginManager.parameters(pluginName);

	const windowSkin = parameters["windowSkin"];
	const windowOpacity = Number(parameters["windowOpacity"]);

	if (windowSkin) {
		Window_Message.prototype.loadWindowskin = function() {
			this.windowskin = ImageManager.loadSystem(windowSkin);
		};
		Window_NameBox.prototype.loadWindowskin = function() {
			this.windowskin = ImageManager.loadSystem(windowSkin);
		};
		Window_ChoiceList.prototype.loadWindowskin = function() {
			this.windowskin = ImageManager.loadSystem(windowSkin);
		};
		Window_NumberInput.prototype.loadWindowskin = function() {
			this.windowskin = ImageManager.loadSystem(windowSkin);
		};
		Window_MenuActor.prototype.loadWindowskin = function() {
			this.windowskin = ImageManager.loadSystem(windowSkin);
		};
		Window_GameEnd.prototype.loadWindowskin = function() {
			this.windowskin = ImageManager.loadSystem(windowSkin);
		};
	}

	if (windowOpacity > -1) {
		Window_Message.prototype.updateBackOpacity = function() {
			this.backOpacity = windowOpacity;
		};
		Window_NameBox.prototype.updateBackOpacity = function() {
			this.backOpacity = windowOpacity;
		};
		Window_ChoiceList.prototype.updateBackOpacity = function() {
			this.backOpacity = windowOpacity;
		};
		Window_NumberInput.prototype.updateBackOpacity = function() {
			this.backOpacity = windowOpacity;
		};
		Window_MenuActor.prototype.updateBackOpacity = function() {
			this.backOpacity = windowOpacity;
		};
		Window_GameEnd.prototype.updateBackOpacity = function() {
			this.backOpacity = windowOpacity;
		};
	}

	const _Window_MenuActor_adjustSelectableWindowSpriteSize = Window_MenuActor.prototype.adjustSelectableWindowSpriteSize;
	if (_Window_MenuActor_adjustSelectableWindowSpriteSize) {
		const _Window_MenuActor_initialize = Window_MenuActor.prototype.initialize;
		Window_MenuActor.prototype.initialize = function(rect) {
			_Window_MenuActor_initialize.call(this, rect);
			this.opacity = 255;
		};
		Window_MenuActor.prototype.adjustSelectableWindowSpriteSize = function() {
			_Window_MenuActor_adjustSelectableWindowSpriteSize.call(this);
			this._selectableWindows.forEach(sprite => {
				sprite.windowskin = ImageManager.loadSystem("Window");
				sprite.backOpacity = $gameSystem.windowOpacity();
			});
		};
	}
}